/*
 * Decompiled with CFR 0.152.
 */
package blue.thejester.simpledelights;

import blue.thejester.simpledelights.SimpleDelights;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import vectorwing.farmersdelight.items.ConsumableItem;
import vectorwing.farmersdelight.registry.ModEffects;

public class SDItems {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"simpledelights");
    public static final RegistryObject<Item> SQUASH_NOODLES = SDItems.makeFood("squash_noodles", 3, 0.6f, new Supplier[0]);
    public static final RegistryObject<Item> DINO_OATMEAL = SDItems.makeBowlFood("dino_oatmeal", 8, 1.2f, SDItems.comfort());
    public static final RegistryObject<Item> JAM_BAR = SDItems.makeFood("jam_bar", 8, 1.2f, SDItems.effect(Effects.field_76424_c, 500));
    public static final RegistryObject<Item> GRANOLA = SDItems.makeFood("granola", 6, 1.2f, new Supplier[0]);
    public static final RegistryObject<Item> GLAZED_YAMS = SDItems.makeFood("glazed_yam", 7, 1.6f, SDItems.comfort());
    public static final RegistryObject<Item> LETTUCE_WRAP = SDItems.makeFood("lettuce_wrap", 11, 1.2f, SDItems.effect(Effects.field_180152_w, 3000));
    public static final RegistryObject<Item> STRAWBERRY_SHORTCAKE = SDItems.makeFood("strawberry_shortcake", 10, 1.2f, SDItems.effect(Effects.field_76428_l, 240));
    public static final RegistryObject<Item> CHOCOLATE_STRAWBERRIES = SDItems.makeFood("chocolate_strawberries", 4, 0.6f, new Supplier[0]);
    public static final RegistryObject<Item> PLUM_PUDDING = SDItems.makeFood("plum_pudding", 8, 1.6f, SDItems.effect(Effects.field_76429_m, 900));
    public static final RegistryObject<Item> PLUM_PORK = SDItems.makeFood("plum_pork", 12, 1.6f, SDItems.effect(Effects.field_76444_x, 240));
    public static final RegistryObject<Item> FRUIT_TART = SDItems.makeFood("fruit_tart", 9, 1.6f, SDItems.effect(Effects.field_76424_c, 600));
    public static final RegistryObject<Item> CREAMCICLE = SDItems.makeFoodBase("creamcicle", 9, 1.6f, Items.field_151055_y, 64, SDItems.effect(Effects.field_76426_n, 600));
    public static final RegistryObject<Item> MANGO_HABANERO_WINGS = SDItems.makeFood("mango_wings", 10, 1.6f, SDItems.effect(Effects.field_76426_n, 3600));
    public static final RegistryObject<Item> SWEET_POTATO_CASSEROLE = SDItems.makeBowlFood("sweet_potato_casserole", 10, 1.6f, SDItems.nourishedLong());
    public static final RegistryObject<Item> STIR_FRY = SDItems.makeBowlFood("stir_fry", 12, 1.0f, SDItems.nourishedLong());
    public static final RegistryObject<Item> DUBU_JJIGAE = SDItems.makeBowlFood("dubu_jjigae", 10, 1.6f, SDItems.comfort());
    public static final RegistryObject<Item> MAPO_TOFU = SDItems.makeBowlFood("mapo_tofu", 12, 1.6f, SDItems.nourishedLong());
    public static final RegistryObject<Item> CHOLENT = SDItems.makeBowlFood("cholent", 12, 1.6f, SDItems.comfort());
    public static final RegistryObject<Item> BERRY_KOMPOT = SDItems.makeFoodBase("berry_kompot", 6, 1.2f, Items.field_151069_bo, 4, SDItems.effect(Effects.field_76424_c, 1200));
    public static final RegistryObject<Item> PEAR_BISQUE = SDItems.makeBowlFood("pear_bisque", 8, 1.6f, SDItems.comfort());
    public static final RegistryObject<Item> ORANGE_CHICKEN = SDItems.makeBowlFood("orange_chicken", 10, 1.6f, SDItems.nourishedLong());
    public static final RegistryObject<Item> ORANGE_SORBET = SDItems.makeBowlFood("orange_sorbet", 7, 1.2f, SDItems.effect(Effects.field_76421_d, 200), SDItems.effect(Effects.field_76426_n, 1200));
    public static final RegistryObject<Item> MANGO_SORBET = SDItems.makeBowlFood("mango_sorbet", 7, 1.2f, SDItems.effect(Effects.field_76421_d, 200), SDItems.effect(Effects.field_76426_n, 1200));
    public static final RegistryObject<Item> SUMMER_SALAD = SDItems.makeBowlFood("summer_salad", 9, 1.2f, SDItems.effect(Effects.field_76427_o, 200));

    private static RegistryObject<Item> makeBowlFood(String name, int hunger, float saturation, Supplier<EffectInstance> ... effects) {
        return SDItems.makeFoodBase(name, hunger, saturation, Items.field_151054_z, 16, effects);
    }

    private static RegistryObject<Item> makeFood(String name, int hunger, float saturation, Supplier<EffectInstance> ... effects) {
        return SDItems.makeFoodBase(name, hunger, saturation, null, 64, effects);
    }

    private static RegistryObject<Item> makeFoodBase(String name, int hunger, float saturation, Item container, int stack, Supplier<EffectInstance> ... effects) {
        Food.Builder f = new Food.Builder().func_221456_a(hunger).func_221454_a(saturation);
        for (Supplier<EffectInstance> effect : effects) {
            f.effect(effect, 1.0f);
        }
        return ITEMS.register(name, () -> new ConsumableItem(new Item.Properties().func_221540_a(f.func_221453_d()).func_200919_a(container).func_200917_a(stack).func_200916_a(SimpleDelights.ITEM_GROUP)));
    }

    private static Supplier<EffectInstance> effect(Effect effect, int duration, int amp) {
        return () -> new EffectInstance(effect, duration, amp);
    }

    private static Supplier<EffectInstance> effect(Effect effect, int duration) {
        return () -> new EffectInstance(effect, duration, 0);
    }

    private static Supplier<EffectInstance> comfort() {
        return () -> new EffectInstance((Effect)ModEffects.COMFORT.get(), 4800, 0);
    }

    private static Supplier<EffectInstance> nourishedShort() {
        return () -> new EffectInstance((Effect)ModEffects.NOURISHED.get(), 4800, 0);
    }

    private static Supplier<EffectInstance> nourishedLong() {
        return () -> new EffectInstance((Effect)ModEffects.NOURISHED.get(), 9600, 0);
    }

    public static void register() {
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static Collection<ResourceLocation> itemList() {
        return ITEMS.getEntries().stream().map(RegistryObject::getId).collect(Collectors.toList());
    }
}

